/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: ProfibusFspms_Common.h 54587 2015-06-18 05:59:24Z RalfH $

Description:
  This file contains definition of structures of FSPM

**************************************************************************************/
#ifndef __PROFIBUS_FSPM_COMMON_H
#define __PROFIBUS_FSPM_COMMON_H


/****************************************************************************************
 * Profibus Fspms, constants
 *
 */

  #define PROFIBUS_FSPM_MAX_DIAG_DATA_SIZE 238          /* Maximum supported diagnostic data size, exlusive 6 standard bytes */

  #define PROFIBUS_FSPM_MAX_USER_PRM_DATA_SIZE 237      /* Maximum supported user parameter data size */

  #define PROFIBUS_FSPM_MAX_DLPDU_SIZE 246

  #define PROFIBUS_FSPMS_MAX_CFG_DATA_SIZE 244           /* Maximum supported config size */
  #define PROFIBUS_FSPMS_MAX_SET_SLAVE_ADD_DATA_SIZE 240 /* Maximum supported set slave address permanent user data */
  #define PROFIBUS_FSPMS_MAX_EXT_USER_PRM_DATA_SIZE 244  /* Maximum supported extended user parameter data size */
  #define PROFIBUS_FSPMS_MAX_INPUT_DATA_SIZE 244         /* Maximum supported input data length */
  #define PROFIBUS_FSPMS_MAX_OUTPUT_DATA_SIZE 244        /* Maximum supported output data length */
  #define PROFIBUS_FSPMS_OUTPUT_STATUS_SIZE   4          /* Number of status bytes behind output data */

  #define PROFIBUS_FSPMS_MAX_ACYCLIC_DATA_SIZE 244       /* Maximum supported acyclic data length */
  #define PROFIBUS_FSPMS_MAX_ACYCLIC_CLASS2_DATA_SIZE 240/* Maximum supported acyclic class2 data length */

  #define PROFIBUS_FSPMS_MAX_READ_DATA_SIZE 240          /* Maximum supported acyclic read data length */
  #define PROFIBUS_FSPMS_MAX_WRITE_DATA_SIZE 240         /* Maximum supported acyclic write data length */

  #define PROFIBUS_FSPMS_MAX_DATA_TRANSPORT_DATA_SIZE 240 /* Maximum supported acyclic transport data length */

  #define PROFIBUS_FSPMS_MAX_INITIATE_ADD_TABLE_SIZE  234 /* Maximum supported acyclic initiate address data length */

  #define PROFIBUS_FSPMS_MAX_ALARM_USERDATA_SIZE 59       /* Maximum allowed user specific Alarm data */

  /* ErrorDecode, ErrorClass1 and 2 field */
  #define PROFIBUS_FSPMS_ERROR_DECODE_DPV1 128
  #define PROFIBUS_FSPMS_ERROR_CLASS_APPLICATION 0xA0 /* Application error class */
  #define PROFIBUS_FSPMS_ERROR_CLASS_ACCESS      0xB0 /* Access error class */
  #define PROFIBUS_FSPMS_ERROR_CLASS_RESOURCE    0xC0 /* Resource error class */

  #define PROFIBUS_FSPMS_ERROR_CODE_APPL_READ          0x00
  #define PROFIBUS_FSPMS_ERROR_CODE_APPL_WRITE         0x01
  #define PROFIBUS_FSPMS_ERROR_CODE_APPL_MODULE        0x02
  #define PROFIBUS_FSPMS_ERROR_CODE_APPL_VERSION       0x08
  #define PROFIBUS_FSPMS_ERROR_CODE_APPL_NOT_SUPPORTED 0x09

  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_INDEX             0x00
  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_WRITE_LENGTH      0x01
  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_SLOT_INVALID      0x02
  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_TYPE_CONFLICT     0x03
  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_AREA_INVALID      0x04
  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_STATE_CONFLICT    0x05
  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_ACCESS_DENIED     0x06
  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_RANGE_INVALID     0x07
  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_PARAMETER_INVALID 0x08
  #define PROFIBUS_FSPMS_ERROR_CODE_ACC_TYPE_INVALID      0x09

  #define PROFIBUS_FSPMS_ERROR_CODE_RSC_READ_CONSTRAIN    0x00
  #define PROFIBUS_FSPMS_ERROR_CODE_RSC_WRITE_CONSTRAIN   0x01
  #define PROFIBUS_FSPMS_ERROR_CODE_RSC_BUSY              0x02
  #define PROFIBUS_FSPMS_ERROR_CODE_RSC_UNAVAILABLE       0x03

  #define PROFIBUS_FSPMS_ALARM_ENABLED_PULL_PLUG             0x80
  #define PROFIBUS_FSPMS_ALARM_ENABLED_PROCESS               0x40
  #define PROFIBUS_FSPMS_ALARM_ENABLED_DIAGNOSTIC            0x20
  #define PROFIBUS_FSPMS_ALARM_ENABLED_MANUFACTURER_SPECIFIC 0x10
  #define PROFIBUS_FSPMS_ALARM_ENABLED_STATUS                0x08
  #define PROFIBUS_FSPMS_ALARM_ENABLED_UPDATE                0x04


  #define PROFIBUS_FSPMS_MSAC2_SUBNET_NO                     0x00
  #define PROFIBUS_FSPMS_MSAC2_SUBNET_LOCAL                  0x01
  #define PROFIBUS_FSPMS_MSAC2_SUBNET_REMOTE                 0x02

  #define PROFIBUS_FSPMS_MSAC2_INSTANCE_DLL                  0x00
  #define PROFIBUS_FSPMS_MSAC2_INSTANCE_MSAC2                0x10
  #define PROFIBUS_FSPMS_MSAC2_INSTANCE_USER                 0x20

  #define PROFIBUS_FSPMS_MSAC2_ERR_ABT_FE                    0x02
  #define PROFIBUS_FSPMS_MSAC2_ERR_ABT_RE                    0x04
  #define PROFIBUS_FSPMS_MSAC2_ERR_ABT_SE                    0x01
  #define PROFIBUS_FSPMS_MSAC2_ERR_ABT_TO                    0x03
  #define PROFIBUS_FSPMS_MSAC2_ERR_ABT_IA                    0x07

  #define PROFIBUS_FSPMS_MSAC2_INITIATE                      0x00
  #define PROFIBUS_FSPMS_MSAC2_VALID_SERVICE                 0x01

  #define PROFIBUS_MAX_MODULE                                0x18

  typedef enum PROFIBUS_FSPMS_DATA_RATEtag{
    PROFIBUS_FSPMS_DATA_RATE_96     =  0,
    PROFIBUS_FSPMS_DATA_RATE_19_2   =  1,
    PROFIBUS_FSPMS_DATA_RATE_93_75  =  2,
    PROFIBUS_FSPMS_DATA_RATE_187_5  =  3,
    PROFIBUS_FSPMS_DATA_RATE_500    =  4,
    PROFIBUS_FSPMS_DATA_RATE_1500   =  6,
    PROFIBUS_FSPMS_DATA_RATE_3000   =  7,
    PROFIBUS_FSPMS_DATA_RATE_6000   =  8,
    PROFIBUS_FSPMS_DATA_RATE_12000  =  9,
    PROFIBUS_FSPMS_DATA_RATE_31_25  = 10,
    PROFIBUS_FSPMS_DATA_RATE_45_45  = 11,
    PROFIBUS_FSPMS_DATA_RATE_AUTO   = 15
  } PROFIBUS_FSPMS_DATA_RATE;


  #define PROFIBUS_FSPM_APDU_GET_MASTER_DIAG_REQ_PDU 0x41
  #define PROFIBUS_FSPM_APDU_GET_MASTER_DIAG_RES_PDU 0x41
  #define PROFIBUS_FSPM_APDU_GET_MASTER_DIAG_NRS_PDU 0xC1

  #define PROFIBUS_FSPM_APDU_START_SEQ_REQ_PDU 0x42
  #define PROFIBUS_FSPM_APDU_START_SEQ_RES_PDU 0x42
  #define PROFIBUS_FSPM_APDU_START_SEQ_NRS_PDU 0xC2

  #define PROFIBUS_FSPM_APDU_DOWNLOAD_REQ_PDU 0x43
  #define PROFIBUS_FSPM_APDU_DOWNLOAD_RES_PDU 0x43
  #define PROFIBUS_FSPM_APDU_DOWNLOAD_NRS_PDU 0xC3

  #define PROFIBUS_FSPM_APDU_UPLOAD_REQ_PDU 0x44
  #define PROFIBUS_FSPM_APDU_UPLOAD_RES_PDU 0x44
  #define PROFIBUS_FSPM_APDU_UPLOAD_NRS_PDU 0xC4

  #define PROFIBUS_FSPM_APDU_END_SEQ_REQ_PDU 0x45
  #define PROFIBUS_FSPM_APDU_END_SEQ_RES_PDU 0x45
  #define PROFIBUS_FSPM_APDU_END_SEQ_NRS_PDU 0xC5

  #define PROFIBUS_FSPM_APDU_ACT_PARA_BRCT_REQ_PDU 0x46
  #define PROFIBUS_FSPM_APDU_ACT_PARA_BRCT_RES_PDU 0x46
  #define PROFIBUS_FSPM_APDU_ACT_PARA_BRCT_NRS_PDU 0xC6

  #define PROFIBUS_FSPM_APDU_ACT_PARAM_REQ_PDU 0x47
  #define PROFIBUS_FSPM_APDU_ACT_PARAM_RES_PDU 0x47
  #define PROFIBUS_FSPM_APDU_ACT_PARAM_NRS_PDU 0xC7

  #define PROFIBUS_FSPM_APDU_IDLE_REQ_PDU 0x48
  #define PROFIBUS_FSPM_APDU_IDLE_RES_PDU 0x48
  #define PROFIBUS_FSPM_APDU_IDLE_NRS_PDU 0xC8

  #define PROFIBUS_FSPM_APDU_DATA_TRANSPORT_REQ_PDU 0x51
  #define PROFIBUS_FSPM_APDU_DATA_TRANSPORT_RES_PDU 0x51
  #define PROFIBUS_FSPM_APDU_DATA_TRANSPORT_NRS_PDU 0xD1

  #define PROFIBUS_FSPM_APDU_RM_REQ_PDU 0x56
  #define PROFIBUS_FSPM_APDU_RM_RES_PDU 0x56
  #define PROFIBUS_FSPM_APDU_RM_NRS_PDU 0xD6

  #define PROFIBUS_FSPM_APDU_INITIATE_REQ_PDU 0x57
  #define PROFIBUS_FSPM_APDU_INITIATE_RES_PDU 0x57
  #define PROFIBUS_FSPM_APDU_INITIATE_NRS_PDU 0xD7

  #define PROFIBUS_FSPM_APDU_ABORT_REQ_PDU 0x58
  #define PROFIBUS_FSPM_APDU_ABORT_RES_PDU 0x58
  #define PROFIBUS_FSPM_APDU_ABORT_NRS_PDU 0xD8

  #define PROFIBUS_FSPM_APDU_ALARM_ACK_REQ_PDU 0x5C
  #define PROFIBUS_FSPM_APDU_ALARM_ACK_RES_PDU 0x5C
  #define PROFIBUS_FSPM_APDU_ALARM_ACK_NRS_PDU 0xDC

  #define PROFIBUS_FSPM_APDU_READ_REQ_PDU 0x5E
  #define PROFIBUS_FSPM_APDU_READ_RES_PDU 0x5E
  #define PROFIBUS_FSPM_APDU_READ_NRS_PDU 0xDE

  #define PROFIBUS_FSPM_APDU_WRITE_REQ_PDU 0x5F
  #define PROFIBUS_FSPM_APDU_WRITE_RES_PDU 0x5F
  #define PROFIBUS_FSPM_APDU_WRITE_NRS_PDU 0xDF

/****************************************************************************************
* Profibus Fspm, common structures */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(PROFIBUS_FSPM_COMMON)
#endif

  /* APDU structure */
  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_APDU_INITIATE_REQ_Ttag {
    TLR_UINT8 bFunction_Num;
    TLR_UINT8 bReserved[3];
    TLR_UINT16 usSend_Timeout;
    TLR_UINT16 usFeatures_Supported;
    TLR_UINT16 usProfile_Features_Supported;
    TLR_UINT16 usProfile_Ident_Number;
    TLR_UINT8  bAdd_Addr_Param[PROFIBUS_FSPM_MAX_DLPDU_SIZE - 10];
  }__TLR_PACKED_POST PROFIBUS_FSPM_APDU_INITIATE_REQ_T;

  /* APDU structure */
  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_APDU_INITIATE_RES_Ttag {
    TLR_UINT8 bFunction_Num;
    TLR_UINT8 bMax_Len_Data;
    TLR_UINT16 usFeatures_Supported;
    TLR_UINT16 usProfile_Features_Supported;
    TLR_UINT16 usProfile_Ident_Number;
    TLR_UINT8  bAdd_Addr_Param[PROFIBUS_FSPM_MAX_DLPDU_SIZE - 10];
  }__TLR_PACKED_POST PROFIBUS_FSPM_APDU_INITIATE_RES_T;


  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_ADD_ADDR_PARAM_Ttag {
    TLR_UINT8 bS_Type;
    TLR_UINT8 bS_Len;
    TLR_UINT8 bD_Type;
    TLR_UINT8 bD_Len;
    TLR_UINT8 bAddr_Data[1];  /* len is defined by S_len or D_len !! */
  }__TLR_PACKED_POST PROFIBUS_FSPM_ADD_ADDR_PARAM_T;


  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_PARAMETER_DPV0_PRM_Ttag {
    TLR_UINT8 abUsr_Prm_Data[PROFIBUS_FSPM_MAX_USER_PRM_DATA_SIZE];  /* user parameter data without DPV1-bytes */
  }__TLR_PACKED_POST PROFIBUS_FSPM_PARAMETER_DPV0_PRM_T;

  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_PARAMETER_DPV1_USR_PRM_Ttag {

    #define MSK_DPV1_STATUS_1_RESERVED1    0x03
    #define MSK_DPV1_STATUS_1_WD_BASE1MS   0x04
    #define MSK_DPV1_STATUS_1_RESERVED2    0x18
    #define MSK_DPV1_STATUS_1_PUBLISHER_EN 0x20
    #define MSK_DPV1_STATUS_1_FAIL_SAFE    0x40
    #define MSK_DPV1_STATUS_1_DPV1_ENABLED 0x80
    TLR_UINT8 bDPV1_Status_1;

    #define MSK_DPV1_STATUS_2_RUN_ON_CFG_FAULT    0x01
    #define MSK_DPV1_STATUS_2_RESERVED1           0x02
    #define MSK_DPV1_STATUS_2_EN_UPD_ALARM        0x04
    #define MSK_DPV1_STATUS_2_EN_STATUS_ALARM     0x08
    #define MSK_DPV1_STATUS_2_EN_MFG_ALARM        0x10
    #define MSK_DPV1_STATUS_2_EN_DIAG_ALARM       0x20
    #define MSK_DPV1_STATUS_2_EN_PROC_ALARM       0x40
    #define MSK_DPV1_STATUS_2_EN_PULL_PLUGALARM   0x80
    TLR_UINT8 bDPV1_Status_2;

    #define MSK_DPV1_STATUS_3_ALARM_MODE          0x07
    #define MSK_DPV1_STATUS_3_PRM_STRUCTURE       0x08
    #define MSK_DPV1_STATUS_3_ISOM_REQ            0x10
    #define MSK_DPV1_STATUS_3_RESERVED1           0x60
    #define MSK_DPV1_STATUS_3_PRM_CMD             0x80

    TLR_UINT8 bDPV1_Status_3;

  }__TLR_PACKED_POST PROFIBUS_FSPM_PARAMETER_DPV1_USR_PRM_T;

  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_PARAMETER_DPV1_PRM_Ttag {
    PROFIBUS_FSPM_PARAMETER_DPV1_USR_PRM_T tDpv1;
    TLR_UINT8     abUsr_Prm_Data[PROFIBUS_FSPM_MAX_USER_PRM_DATA_SIZE-sizeof(PROFIBUS_FSPM_PARAMETER_DPV1_USR_PRM_T)];
  }__TLR_PACKED_POST PROFIBUS_FSPM_PARAMETER_DPV1_PRM_T;


  #define PROFIBUS_FSPM_STRUCTURE_TYPE_PRM_CMD             0x02
  #define PROFIBUS_FSPM_STRUCTURE_TYPE_DXB_LINKTABLE       0x03
  #define PROFIBUS_FSPM_STRUCTURE_TYPE_ISOM_PARAMETER      0x04
  #define PROFIBUS_FSPM_STRUCTURE_TYPE_DXB_SUBSCRIBERTABLE 0x07


  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_PARAMETER_DPV2_HEADER_Ttag {
    TLR_UINT8     bStructure_Length;
    TLR_UINT8     bStructure_Type;
    TLR_UINT8     bSlot_Number;
    TLR_UINT8     bReserved;
  }__TLR_PACKED_POST PROFIBUS_FSPM_PARAMETER_DPV2_HEADER_T;

  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_PARAMETER_DPV2_ISOM_PRM_Ttag {
    PROFIBUS_FSPM_PARAMETER_DPV2_HEADER_T tDpv2Header;
    TLR_UINT8  bVersion;
    TLR_UINT32 bTBase_Dp;
    TLR_UINT16 bTDp;
    TLR_UINT8  bTMapc;
    TLR_UINT32 bTBase_Io;
    TLR_UINT16 bTI;
    TLR_UINT16 bTO;
    TLR_UINT32 bTDx;
    TLR_UINT16 bTPll_W;
    TLR_UINT16 bTPll_D;
  }__TLR_PACKED_POST PROFIBUS_FSPM_PARAMETER_DPV2_ISOM_PRM_T;

  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_PARAMETER_DPV2_DBX_LINK_FILTER_Ttag {
    TLR_UINT8 bPublisher_Addr;
    TLR_UINT8 bPublisher_Length;
    TLR_UINT8 bSample_Offset;
    TLR_UINT8 bSample_Length;
  }__TLR_PACKED_POST PROFIBUS_FSPM_PARAMETER_DPV2_DBX_LINK_FILTER_T;

  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_PARAMETER_DPV2_DBX_LINK_Ttag {
    PROFIBUS_FSPM_PARAMETER_DPV2_HEADER_T tDpv2Header;
    TLR_UINT8 bVersion;
    PROFIBUS_FSPM_PARAMETER_DPV2_DBX_LINK_FILTER_T tDbxLinkFilter;
  }__TLR_PACKED_POST PROFIBUS_FSPM_PARAMETER_DPV2_DBX_LINK_T;

  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_PARAMETER_DPV2_PRM_Ttag {
    PROFIBUS_FSPM_PARAMETER_DPV1_USR_PRM_T tDpv1;
    PROFIBUS_FSPM_PARAMETER_DPV2_ISOM_PRM_T tDpv2Iso;
    TLR_UINT8 abUsr_Prm_Data[PROFIBUS_FSPM_MAX_USER_PRM_DATA_SIZE-
                             sizeof(PROFIBUS_FSPM_PARAMETER_DPV1_USR_PRM_T)-
                             sizeof(PROFIBUS_FSPM_PARAMETER_DPV2_ISOM_PRM_T)];
  }__TLR_PACKED_POST PROFIBUS_FSPM_PARAMETER_DPV2_PRM_T;

  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_PARAMETER_DATA_Ttag {


    #define MSK_FSPM_PARAMETER_STATION_STATUS_RESERVED    0x07
    #define MSK_FSPM_PARAMETER_STATION_STATUS_WD_ON       0x08
    #define MSK_FSPM_PARAMETER_STATION_STATUS_FREEZE_REQ  0x10
    #define MSK_FSPM_PARAMETER_STATION_STATUS_SYNC_REQ    0x20
    #define MSK_FSPM_PARAMETER_STATION_STATUS_UNLOCK_REQ  0x40
    #define MSK_FSPM_PARAMETER_STATION_STATUS_LOCK_REQ    0x80
    TLR_UINT8  bStation_Status;             /* status of supported functions */

    TLR_UINT8  bWD_Fact_1;     /* watchdog factor 1 */
    TLR_UINT8  bWD_Fact_2;     /* watchdog factor 2 */
    TLR_UINT8  bMin_Tsdr;      /* min. station delay reponder */
    TLR_UINT16 usIdent_Number; /* ident number of the station, motorola format */
    TLR_UINT8  bGroup_Ident;   /* configures group number */

    __TLR_PACKED_PRE union
    {
      PROFIBUS_FSPM_PARAMETER_DPV0_PRM_T tDpv0;     /* standard parameter , or */
      PROFIBUS_FSPM_PARAMETER_DPV1_PRM_T tDpv1Only; /* parameter data with DPV1 */
      PROFIBUS_FSPM_PARAMETER_DPV2_PRM_T tDpv1Dpv2; /* parameter data with DPV1,DPV2 */
    }__TLR_PACKED_POST un;
  }__TLR_PACKED_POST PROFIBUS_FSPM_PARAMETER_DATA_T;



  #define PROFIBUS_FSPM_DIAGNOSTIC_MASTER_ADD_INVALID 0xFF

  typedef __TLR_PACKED_PRE struct PROFIBUS_FSPM_DIAGNOSTIC_DATA_Ttag {

    #define MSK_FSPM_DIAGNOSTIC_STAT1_STATE_NON_EXISTENT 0x01
    #define MSK_FSPM_DIAGNOSTIC_STAT1_STATE_NOT_READY    0x02
    #define MSK_FSPM_DIAGNOSTIC_STAT1_STATE_CFG_FAULT    0x04
    #define MSK_FSPM_DIAGNOSTIC_STAT1_STATE_EXT_DIAG     0x08
    #define MSK_FSPM_DIAGNOSTIC_STAT1_STATE_NOT_SUPP     0x10
    #define MSK_FSPM_DIAGNOSTIC_STAT1_STATE_INVALID_RESP 0x20
    #define MSK_FSPM_DIAGNOSTIC_STAT1_STATE_PRM_FAULT    0x40
    #define MSK_FSPM_DIAGNOSTIC_STAT1_STATE_MASTER_LOCK  0x80
    TLR_UINT8 bStationstatus_1;

    #define MSK_FSPM_DIAGNOSTIC_STAT2_STATE_PRM_REQ      0x01
    #define MSK_FSPM_DIAGNOSTIC_STAT2_STATE_STAT_DIAG    0x02
    #define MSK_FSPM_DIAGNOSTIC_STAT2_STATE_TRUE         0x04
    #define MSK_FSPM_DIAGNOSTIC_STAT2_STATE_WD_ON        0x08
    #define MSK_FSPM_DIAGNOSTIC_STAT2_STATE_FREEZE_MODE  0x10
    #define MSK_FSPM_DIAGNOSTIC_STAT2_STATE_SYNC_MODE    0x20
    #define MSK_FSPM_DIAGNOSTIC_STAT2_STATE_RESERVED     0x40
    #define MSK_FSPM_DIAGNOSTIC_STAT2_STATE_DEACTIVATED  0x80
    TLR_UINT8 bStationstatus_2;

    #define MSK_FSPM_DIAGNOSTIC_STAT3_STATE_RESERVED           0x7F
    #define MSK_FSPM_DIAGNOSTIC_STAT3_STATE_EXT_DIAG_OVERFLOW  0x80
    TLR_UINT8 bStationstatus_3;

    TLR_UINT8 bMaster_Add;               /* corresponding master address */
    TLR_UINT16 usIdent_Number;           /* ident number, motorola format */
    TLR_UINT8 abExt_Diag_Data[PROFIBUS_FSPM_MAX_DIAG_DATA_SIZE];
                                         /* extended diagnostic field */
  }__TLR_PACKED_POST PROFIBUS_FSPM_DIAGNOSTIC_DATA_T;

  #define PROFIBUS_FSPM_DIAGNOSTIC_DATA_SIZE (sizeof(PROFIBUS_FSPM_DIAGNOSTIC_DATA_T) - PROFIBUS_FSPM_MAX_DIAG_DATA_SIZE)

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(PROFIBUS_FSPM_COMMON)
#endif


/***************************************************************************************/
#endif /* #ifndef __PROFIBUS_FSPM_COMMON_H */
